/*
 * Error handling routines
 */
#include "libfma.h"
#include "lf_internal.h"

/* callback for handing an error string to a caller */
void (*lf_error_rtn)(char *, int, int, char *) = NULL;

/*
 * Set the routine to be used to deliver error strings back to the
 * caller.  If unset, errors are just reported to stderr.
 * Calling error_rtn with "NULL" means unable to allocate
 * space to hold the error string.
 */
void
lf_set_error_handler(
  void (*error_rtn)(char *, int, int, char *))
{
  lf_error_rtn = error_rtn;
}
